<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use DB;
use App\Traits\DeleteModelTrait; 

class SliderController extends Controller
{
    use DeleteModelTrait;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        try{
            DB::beginTransaction();
            //validating form data
            $validatedData = $request->validate([
                'title' => 'required|min:3', 
                'status' => 'required',
                'description' => 'required',
            
            ]);

            // If the status is "active", reset all other sliders to "inactive"
            if ($validatedData['status'] == true) {
                Slider::where('status', true)->update(['status' => false]);
            }

            $slider = new Slider;
            $slider->title = $validatedData['title'];
            $slider->status = $validatedData['status'];
            $slider->description = $validatedData['description'];
            $slider->save();

            DB::commit();
            return redirect()->route('admin.sliders')->with('success', [
                'message' => 'Slider created successfully',
                'check' => false
            ]);
        } catch (ValidationException $e) {
            DB::rollBack();
            return redirect()->back()
                ->withErrors($e->errors()) 
                ->withInput(); 

        } catch(\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with('error', [
                'message' => 'An error occurred:' . $e->getMessage(),
                'check'   => false
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Slider $slider)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $slider = Slider::findOrFail($id);
        return response()->json($slider);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        try {
            DB::beginTransaction();
            $validatedData = $request->validate([
                'title' => 'required|min:3', 
                'description' => 'required|min:10',
                'status' => 'required',
                
            ]);

            // Retrieve the slider or fail.
            $slider = Slider::findOrFail($id);

            // If the status is "active", reset all other sliders to "inactive"
            if ($validatedData['status'] == true) {
                Slider::where('status', true)->update(['status' => false]);
            }
            $slider->fill($validatedData);
            if ($slider->isDirty()){
                $slider->save();
            }

            DB::commit();

            return Redirect::back()->with('success', [
                'message' => 'Slider updated successfully',
                'check'   => false
            ]);
        } catch (ValidationException $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Validation error: ' . $e->getMessage(),
                'check'   => $e->getMessage()
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return Redirect::back()->with('error', [
                'message' => 'Error: ' . $e->getMessage(),
                'check'   => $e->getMessage()
            ]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        return $this->deleteModel($id, new Slider());
    }

    public function fetchSliders()
    {
        // Fetch all sliders
        $sliders = Slider::orderBy('created_at', 'desc')->get();
        return Inertia::render('sliders/Slider', [
            'sliders' => $sliders->map(function ($slider) {
                return $slider->only('id','title','description' ,'status','created_at');
            }),
        ]);
    }
}
