<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

use App\Models\Booking;

class BookingStatusUpdateMail extends Mailable
{
    use Queueable, SerializesModels;
    public $bookingData;


    /**
     * Create a new message instance.
     */
    public function __construct(Booking $booking)
    {
        //
        $this->bookingData = $booking;

    }

    public function build()
    {
        $companyInfo = \App\Models\CompanyInformation::first();
        
        return $this->subject("Your Booking Status Update - Matergo Hotel")
                    ->view('emails.booking_status_update', [
                        'companyInfo' => $companyInfo
                    ]);
    }
}
