<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    protected $fillable = [
        'booking_reference',
        'full_name',
        'email',
        'phone',
        'number_of_people',
        'number_of_adults',
        'number_of_children',
        'special_request',
        'accommodation_id',
        'room_id',
        'check_in',
        'check_out',
        'event_start',
        'event_end',
        'price',
        'status',
        'confirmed_by',
        'bookable_type',
        'bookable_id',
    ];

    protected $casts = [
        'number_of_adults' => 'integer',
        'number_of_children' => 'integer',
    ];

    public function accommodation()
    {
        return $this->belongsTo(Accommodation::class);
    }

    /**
     * Get the specific room booked (if any)
     */
    public function room()
    {
        return $this->belongsTo(Room::class);
    }

    public function bookable()
    {
        return $this->morphTo();
    }

    /**
     * Optional: Relationship to the user who confirmed the booking
     */
    public function confirmer()
    {
        return $this->belongsTo(User::class, 'confirmed_by');
    }
}
