<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('section_images', function (Blueprint $table) {
            $table->id();
            $table->string('home_about')->nullable();
            $table->string('about_page')->nullable();
            $table->string('besides_mission')->nullable();
            $table->string('hero_background')->nullable();
            $table->timestamps();
        });

        DB::table('section_images')->insert([
            'home_about' => '',
            'about_page' => '',
            'besides_mission' => '',
            'hero_background' => '',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('section_images');
    }
};
