import { Link,usePage } from "@inertiajs/react";

export default function SideBar(){
  const { auth } = usePage().props;
    return(
        <aside className="sidebar-left border-right bg-white shadow" id="leftSidebar" data-simplebar>
        <a href="#" className="btn collapseSidebar toggle-btn d-lg-none text-muted ml-2 mt-3" data-toggle="toggle">
          <i className="fe fe-x"><span className="sr-only"></span></i>
        </a>
        <nav className="vertnav navbar navbar-light">
          {/* <!-- nav bar --> */}
          <div className="w-100 mb-4 d-flex">
            <Link className="navbar-brand mx-auto mt-2 flex-fill text-center" href="/admin/dashboard">
              <img src="/assets/user/images/matergo_website_logo.png" alt="Matergo Hotel" />
            </Link>
          </div>
          <ul className="navbar-nav flex-fill w-100 mb-2">
            <li className="nav-item w-100">
              <Link className="nav-link" href="/admin/dashboard">
                <i className="fe fe-pie-chart fe-16"></i>
                <span className="ml-3 item-text">Overview</span>
              </Link>
              <Link className="nav-link" href="/admin/bookings">
                <i className="fe fe-star fe-16"></i>
                <span className="ml-3 item-text">Bookings</span>
              </Link>
              <Link className="nav-link" href="/admin/bookings/calendar">
                <i className="fe fe-calendar fe-16"></i>
                <span className="ml-3 item-text">Booking Calendar</span>
              </Link>
              <Link className="nav-link" href="/admin/messages">
                <i className="fe fe-message-square fe-16"></i>
                <span className="ml-3 item-text">Messages</span>
              </Link>
            </li>
          </ul>

          <p className="text-muted nav-heading mt-2 mb-1">
            <span>Sections and Pages</span>
          </p>
          <ul className="navbar-nav flex-fill w-100 mb-2">
            <li className="nav-item w-100">
              <Link className="nav-link" href="/admin/gallery">
                <i className="fe fe-image fe-16"></i>
                <span className="ml-3 item-text">Gallery</span>
              </Link>
              <Link className="nav-link" href="/admin/banners">
                <i className="fe fe-airplay fe-16"></i>
                <span className="ml-3 item-text">Banners</span>
              </Link>
              <Link className="nav-link" href="/admin/sliders">
                <i className="fe fe-sliders fe-16"></i>
                <span className="ml-3 item-text">Sliders</span>
              </Link>
              <Link className="nav-link" href="/admin/section_image">
                <i className="fe fe-layers fe-16"></i>
                <span className="ml-3 item-text">Section Images</span>
              </Link>
              <Link className="nav-link" href="/admin/accommodations">
                <i className="fe fe-box fe-16"></i>
                <span className="ml-3 item-text">Accommodations</span>
              </Link>
              <Link className="nav-link" href="/admin/rooms">
                <i className="fe fe-home fe-16"></i>
                <span className="ml-3 item-text">Rooms</span>
              </Link>
              <Link className="nav-link" href="/admin/pricing-rules">
                <i className="fe fe-dollar-sign fe-16"></i>
                <span className="ml-3 item-text">Pricing Rules</span>
              </Link>
              <Link className="nav-link" href="/admin/menus">
                <i className="fe fe-menu fe-16"></i>
                <span className="ml-3 item-text">Menu Items</span>
              </Link>
              <Link className="nav-link" href="/admin/homepage_videos">
                <i className="fe fe-video fe-16"></i>
                <span className="ml-3 item-text">Homepage Videos</span>
              </Link>
              <Link className="nav-link" href="/admin/event_rooms">
                <i className="fe fe-calendar fe-16"></i>
                <span className="ml-3 item-text">Event Rooms</span>
              </Link>
              <Link className="nav-link" href="/admin/testimonials">
                <i className="fe fe-users fe-16"></i>
                <span className="ml-3 item-text">Testimonials</span>
              </Link>
              <Link className="nav-link" href="/admin/faqs">
                <i className="fe fe-help-circle fe-16"></i>
                <span className="ml-3 item-text">FAQs</span>
              </Link>
              <Link className="nav-link" href="/admin/services">
                <i className="fe fe-grid fe-16"></i>
                <span className="ml-3 item-text">Services</span>
              </Link>
            </li>
            
          </ul>

          <p className="text-muted nav-heading mt-2 mb-1">
            <span>Media & Updates</span>
          </p>
          <ul className="navbar-nav flex-fill w-100 mb-2">
            <li className="nav-item w-100">
            </li>
            <li className="nav-item dropdown">
              <a href="#dashboard" data-toggle="collapse" aria-expanded="false" className="dropdown-toggle nav-link">
                <i className="fe fe-edit fe-16"></i>
                <span className="ml-3 item-text">News</span><span className="sr-only">(current)</span>
              </a>
              <ul className="collapse list-unstyled pl-4 w-100" id="dashboard">
                <li className="nav-item active">
                  <Link className="nav-link pl-3" href="/admin/post_category"><span className="ml-1 item-text">New Categories</span></Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link pl-3" href="/admin/posts"><span className="ml-1 item-text">News(Posts)</span></Link>
                </li>
                
              </ul>
            </li>

            <Link className="nav-link" href="/admin/events">
              <i className="fe fe-calendar fe-16"></i>
              <span className="ml-3 item-text">Events</span>
            </Link>


          </ul>

          {auth.user?.role === "admin" && (
            <>
              <p className="text-muted nav-heading mt-2 mb-1">
                <span>Site settings</span>
              </p>
              <ul className="navbar-nav flex-fill w-100 mb-2">
                <li className="nav-item w-100">
                  <Link className="nav-link" href="/admin/company_info">
                    <i className="fe fe-info fe-16"></i>
                    <span className="ml-3 item-text">Company Information</span>
                  </Link>
                  <Link className="nav-link" href="/admin/user">
                    <i className="fe fe-shield fe-16"></i>
                    <span className="ml-3 item-text">Users</span>
                  </Link>
                </li>
              </ul>
            </>
          )}
          <div className="btn-box w-100 mt-2 mb-1">
            <Link href="/admin/logout" className="btn mb-2 btn-primary btn-lg btn-block" method="post">
              <i className="fe fe-log-out fe-12 mx-2"></i><span className="small">Logout</span>
            </Link>
          </div>
        </nav>
      </aside>
    );
}