import React from 'react';
import { router } from '@inertiajs/react';

const DeleteConfirmationModal = ({
    isOpen,
    onClose,
    onConfirmDelete,
    itemName = 'this item',
    itemType = 'record',
    deleteEndpoint
}) => {
    const handleDelete = () => {
        if (deleteEndpoint) {
            router.delete(deleteEndpoint, {
                onSuccess: () => {
                    onConfirmDelete?.();
                    onClose();
                },
            });
        }
    };

    if (!isOpen) return null;

    return (
        <div 
            className="modal fade show"
            id="deleteModal"
            style={{ 
                display: isOpen ? 'block' : 'none', 
                zIndex: 1050,
                backgroundColor: 'rgba(0, 0, 0, 0.5)',
                position: 'fixed',
                top: 0,
                left: 0,
                width: '100%',
                height: '100%'
            }}
        >
            <div className="modal-dialog modal-dialog-centered" role="document">
                <div className="modal-content">
                    <div className="modal-header">
                        <h5 className="modal-title d-flex align-items-center">
                        <i className="fe fe-help-circle mr-2 text-danger"></i><span> </span> 
                            <span> Delete Confirmation</span>
                        </h5>
                        <button 
                            type="button" 
                            className="close" 
                            onClick={onClose} 
                            aria-label="Close"><span>×</span>
                        </button>
                    </div>
                    <div className="modal-body">
                        Are you sure you want to delete <strong>{itemName}</strong>? 
                        This {itemType} will be  removed.
                    </div>
                    <div className="modal-footer">
                        <button
                            type="button"
                            className="btn btn-secondary"
                            onClick={onClose}
                        >
                            Close
                        </button>
                        <button
                            type="button"
                            className="btn btn-danger"
                            onClick={handleDelete}
                        >
                            Delete
                        </button>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default DeleteConfirmationModal;
