import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";

import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditAccommodation from "./EditAccommodation";

export default function Accommodation({accommodations}){
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, accommodation: null });
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Category', key: 'room_category' },
        { header: 'Price FBU', key: 'price_fbu' },
        { header: 'Price USD', key: 'price_usd' },
        { header: 'Status', key: 'status' },
        { header: 'Featured', key: 'featured' },
      ];
    const handleDelete = (row) => {
        setDeleteModal({ show: true, accommodation: row });
    };

    const handleEdit = (row) => {
        if (!row?.id) return;
        
        fetch(`/admin/edit_accommodation/${row.id}`)
        .then((response) => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((accommodationData) => {
            setInitialData(accommodationData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            toast.error('Failed to load accommodation details');
        });
    };

    const transformedAccommodations = (accommodations || []).map(acc => ({
        ...acc,
        status: acc?.status ?? 0,
        featured: acc?.featured ?? 0,
        price_fbu: acc?.price_fbu ? `${parseInt(acc.price_fbu).toLocaleString()} BIF` : 'N/A',
        price_usd: acc?.price_usd ? `$${parseFloat(acc.price_usd).toFixed(2)}` : 'N/A',
    }));
  
    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Accommodations</h2>
            <p className="text-muted">Manage room types and accommodation details</p>
            <Link className="btn mb-4 btn-primary" href="/admin/accommodations/create">
            Create new Accommodation
            </Link>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={transformedAccommodations} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Accommodations"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Accommodations found"
                />
            </Col>
            </Row>
            </Col>
        </Row>
        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, accommodation: null })}
                onConfirmDelete={() => {
                    toast.success("Accommodation Deleted Successfully")
                }}
                itemName={deleteModal.accommodation?.room_name || 'this accommodation'}
                itemType="accommodation"
                deleteEndpoint={`/admin/api/delete_accommodation/${deleteModal?.accommodation?.id}`}
            />
        <EditAccommodation isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}
         />
        </>
    );
}

