import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";

export default function EditGallery({ isOpen, onClose, initialData }){
    const {data, setData, put, processing, errors} = useForm({
        'title': '',
        'photo': '',
        'caption': '',
        'status': true,
    });

    const handleSuccess = (filename) => {
        setData('photo',filename);
    };

     const handleError = (error) => {
        console.error("Upload error:", error);
    };

    useEffect(() => {
        if (initialData) {
          setData({
              title: initialData?.title || '',
              photo: initialData?.photo || '',
              caption: initialData?.caption || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_gallery/${initialData.id}`, {
            preserveScroll: true,
                onSuccess: formResponse.onSuccess, 
                onError: formResponse.onError, 
            });
    };
    

    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title={`Edit ${initialData?.title}`} size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}
        >
            <form onSubmit={handleSave}>
            <FormGroup label="Title (Caption)" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <FileUploadInput label="Upload image (600x600)px" 
            buttonText={"Choose file (600x600)"}
            uploadUrl="/admin/api/gallery/upload_image"
            onSuccess={handleSuccess}
            onError={handleError}
            previewUrl={`/storage/${data.photo}`}

            />

            <FormGroup
            id="caption"
            label="Caption"
            as="textarea"
            value={data.caption}
            helpText="Briefy describe what the image is about. Be precise not more than 255 characters"
            onChange={(e) => setData("caption", e.target.value)}
            rows="4"
            invalidFeedback={errors.caption}
            />
            
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            </form>

        </Modal>
        </>
    );
}