import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";

import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditGallery from "./EditGallery";

export default function Gallery({gallery}){
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, gallery: null });
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Title', key: 'title' },
        { header: 'Photo', key: 'photo' },
        { header: 'Status', key: 'status' },
        
      ];
    const handleDelete = (row) => {
        setDeleteModal({ show: true, gallery: row });
    };

    const handleEdit = (row) => {
        fetch(`/admin/edit_photo/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((gallaryData) => {
            const formattedData = gallaryData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching photo details:', error);
        });
    };
    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Gallery</h2>
            <p className="text-muted">Manage Photos</p>
            <Link className="btn mb-4 btn-primary" href="/admin/gallery/create">
            Add Photo
            </Link>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={gallery} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Photos"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Photos found"
                />
            </Col>
            </Row>
            </Col>
        </Row>
         <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, gallery: null })}
                onConfirmDelete={() => {
                    toast.success("Photo Deleted Successfuly")
                }}
                itemName={deleteModal.gallery?.name || 'this photo'}
                itemType="gallery"
                deleteEndpoint={`/admin/api/delete_gallery/${deleteModal?.gallery?.id}`}
            />

            <EditGallery isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}
            />
        </>
    );
}