import Modal from "@admin/ui/Modal";
import WysiwygEditor from "@admin/ui/forms/WysiwygEditor";
import { useFormResponse } from "@/hooks/useFormResponse";
import { useForm } from "@inertiajs/react";
import { useEffect } from "react";

export default function ReadMessage({ isOpen, onClose, initialData }){
    const {data,setData,post, processing, errors, reset} = useForm({
        'response_to_message': '',
        'email': '',
        'subject': '',
        'message': '',
    });

    useEffect(() => {
        if(initialData?.name) {
            setData('response_to_message', `Hello ${initialData.name}`);
        }
        setData('email',initialData?.email);
        setData('subject',initialData?.subject);
        setData('message',initialData?.message);
    }, [initialData]);

    const handleReply = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.();
        });

        post('/admin/reply_message', {
            preserveScroll: true,
            onSuccess: formResponse.onSuccess,
            onError: formResponse.onError,
        });
        };
        
    return(
        <>
        <Modal
        isOpen={isOpen}
        onClose={onClose}
        title={`Message from ${initialData?.name} - ${initialData?.email}`}
        size="large"
        primaryButtonText="Reply"
        onPrimaryAction={handleReply}
        processing={processing}
        >
        {initialData && (
            <>
            <div className="alert alert-light p-4 shadow-sm" role="alert">
            <h4 className="text-dark">Subject: {initialData.subject}</h4>
            <hr />
            <h6>Message:</h6>
            <>{initialData.message}</>
            </div>
            <h5 className="text-dark">Respond to Message</h5>
            <WysiwygEditor
            value={data.response_to_message}
            onChange={response_to_message => setData('response_to_message', response_to_message)}
            height={400}
            placeholder="Write your response to message  here..."
            toolbar="full" />

            </>
            
        )}
        </Modal>
        </>
    );
}