import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import TagMultiSelect from "@admin/ui/forms/TagMultiSelect";
import WysiwygEditor from "@admin/ui/forms/WysiwygEditor";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";
export default function EditPost({ isOpen, onClose, initialData }){
    const {data, setData, put, processing, errors} = useForm({
        title: '',
        tags: '',
        categories: '',
        photo: '',
        description:'',
        status: true,
    });

    const [categoriesData, setCategories] = useState([]);
    useEffect(() => {
        // Fetch categories
        fetch('/api/post_categories')
            .then((response) => response.json())
            .then((data) => setCategories(data));
    }, []);

    const handleSuccess = (filename) => {
        setData('photo',filename);
    };

     const handleError = (error) => {
        console.error("Upload error:", error);
    };

    useEffect(() => {
        if (initialData) {
          setData({
              title: initialData?.title || '',
              tags: initialData?.tags || '',
              categories: initialData?.categories || '',
              photo: initialData?.photo || '',
              description: initialData?.description || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_post/${initialData.id}`, {
            preserveScroll: true,
                onSuccess: formResponse.onSuccess, 
                onError: formResponse.onError, 
            });
    };
    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title="Edit Testimonial" size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}
        >
            <form onSubmit={handleSave}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <TagMultiSelect
                id="categories"
                label="Select Category"
                options={categoriesData.map((category) => ({
                    label: category.title,
                    value: category.id,
                }))}
                dataSelected={data.categories} 
                invalidFeedback={errors.categories}
                onChange={(selected) => setData((prev) => ({ ...prev, categories: selected }))}
                helpText="Choose one or more categories"
                />
            <FormGroup
            id="tags"
            label="tags"
            as="textarea"
            value={data.tags}
            helpText="Write tags separated by commas"
            onChange={(e) => setData('tags', e.target.value)}
            rows="4"
            invalidFeedback={errors.tags}
            />

            <br />
            <label className="label">Description (Required)</label>
            <WysiwygEditor
            value={data.description}
            onChange={description => setData('description', description)}
            height={400}
            placeholder="Write your description  here..."
            toolbar="full" />
            <br />
            <FileUploadInput label="Upload image (600x400)px" 
            buttonText={"Choose file (600x400)"}
            uploadUrl="/admin/api/post/upload_image"
            previewUrl={`/storage/${data.photo}`}
            onSuccess={handleSuccess}

            onError={handleError}/>
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            </form>
        </Modal>
        </>
    );
}