import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";

import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditCategory from "./EditCategory";

export default function Category({categories}){
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Title', key: 'title' },
        { header: 'Status', key: 'status' },
      ];

    const handleDelete = (row) => {
        setDeleteModal({ show: true, post_category: row });
    };


    const handleEdit = (row) => {
        fetch(`/admin/edit_post_category/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((categoryData) => {
            const formattedData = categoryData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching category details:', error);
        });
    };

    const [categoryData, setCategoryData] = useState([]);
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, post_category: null });
    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Categories</h2>
            <p className="text-muted">Manage event categories</p>
            <Link className="btn mb-4 btn-primary" href="/admin/post_category/create">
            Create new Category
            </Link>
            <Row>
            <Col lg="12">
            {/* <Card md="12" title="Manage Packages"> */}
                <StyledTable 
                data={categories} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Event Categories"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Event Categories found"
                />
            {/* </Card> */}
            </Col>
            </Row>
            </Col>
        </Row>

        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, post_category: null })}
            onConfirmDelete={() => {
                toast.success("Category Deleted Successfuly")
                setCategoryData(prev => prev.filter(item => item.id !== deleteModal.post_category.id));
            }}
            itemName={deleteModal.post_category?.title || 'this category'}
            itemType="post_category"
            deleteEndpoint={`/admin/api/delete_post_category/${deleteModal?.post_category?.id}`}
        />
        <EditCategory isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData} />
        </>
    );
}