import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";
import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditTestimonial from "./EditTestimonial";
export default function Testimonial({testimonials}){
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Name', key: 'name' },
        { header: 'Photo', key: 'photo' },
        { header: 'Status', key: 'status' },
      ];
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, testimonial: null });

    const handleDelete = (row) => {
        setDeleteModal({ show: true, testimonial: row });
    };

    const handleEdit = (row) => {
        fetch(`/admin/edit_testimonial/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((testimonialData) => {
            const formattedData = testimonialData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching testimonial details:', error);
        });
    };

    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Testimonials</h2>
            <p className="text-muted">Manage testimonials</p>
            <Link className="btn mb-4 btn-primary" href="/admin/testimonials/create">
            Create new Testimonial
            </Link>
            <Row>
            <Col lg="12">
            {/* <Card md="12" title="Manage Packages"> */}
                <StyledTable 
                data={testimonials} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Testimonials"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Testimonials found"
                />
            {/* </Card> */}
            </Col>
            </Row>
            </Col>
        </Row>
        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, testimonial: null })}
            onConfirmDelete={() => {
                toast.success("Testimonial Deleted Successfuly")
            }}
            itemName={deleteModal.testimonial?.name || 'this testimonial'}
            itemType="testimonial"
            deleteEndpoint={`/admin/api/delete_testimonial/${deleteModal?.testimonial?.id}`}
        />
        <EditTestimonial isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}

        />
        </>
    );
}