import FormGroup from "@admin/ui/forms/FormGroup";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import { useForm, usePage } from "@inertiajs/react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { Toaster } from "react-hot-toast";
export default function EditProfile(){
    const {user} = usePage().props;
    const {data, setData, put, processing, errors} = useForm({
        name: user?.name || '',
        email: user?.email || '',
        photo:user?.photo || '',
        password: '',
        password_confirmation: '',
        old_password: '',
    });
    
    const handleSuccess = (filename) => {
        setData('photo',filename);
    };

    const handleError = (error) => {
        console.error("Upload error:", error);
    };

    const handleSubmit =  (e) => {
        e.preventDefault();
        const formResponse = useFormResponse();
        put(`/admin/api/update_profile/${user.id}`, {
            preserveScroll: true,
                ...formResponse,
            });
    };
    return(
        <>
        <div>
            <div className="row align-items-center my-4">
                <Toaster />
                <div className="col">
                    <h2 className="h3 mb-0 page-title">User Profile</h2>
                </div>
            </div>
            <form  method="PUT" onSubmit={handleSubmit}>
                <hr className="my-4" />
                <div className="form-row">
                    <div className="form-group col-md-6">
                        <label htmlFor="name">Name</label>
                        <input
                            type="text"
                            id="name"
                            name="name"
                            className="form-control"
                            value={data.name}
                            onChange={(e) => setData('name', e.target.value)}
                            placeholder="Name"
                        />
                    </div>

                    <div className="form-group col-md-6">
                    <label htmlFor="email">Email</label>
                    <input
                        type="email"
                        id="email"
                        name="email"
                        className="form-control"
                        value={data.email}
                        onChange={(e) => setData('email', e.target.value)}
                        placeholder="Email"
                        autocomplete="off"
                    />
                    </div>

                </div>

                <FileUploadInput label="Upload image (200x200)px" 
                buttonText={"Choose file (200x200)"}
                uploadUrl="/admin/api/user/upload_image"
                onSuccess={handleSuccess}
                onError={handleError}
                previewUrl={`/storage/${data.photo}`}

                />
                
                <hr className="my-4" />
                <div className="row mb-4">
                    <div className="col-md-6">
                        <FormGroup label=" Old Password (Current Password)" 
                        type="password"
                        value={data.old_password}
                        onChange={(e) => setData('old_password', e.target.value)}
                        invalidFeedback={errors.old_password}
                        />

                        <FormGroup label="New Password" 
                        type="password"
                        value={data.password}
                        onChange={(e) => setData('password', e.target.value)}
                        invalidFeedback={errors.password}
                        />
                        
                        <div className="form-group">
                            <label htmlFor="password_confirmation">Confirm Password</label>
                            <input
                                type="password"
                                id="password_confirmation"
                                name="password_confirmation"
                                className="form-control"
                                value={data.password_confirmation}
                                onChange={(e) => setData('password_confirmation', e.target.value)}
                                placeholder="Confirm New Password"
                            />
                        </div>
                    </div>
                    <div className="col-md-6">
                        <p className="mb-2">Password requirements</p>
                        <p className="small text-muted mb-2">
                            To create a new password, you have to meet all of the following requirements:
                        </p>
                        <ul className="small text-muted pl-4 mb-0">
                            <li>Minimum 8 characters</li>
                            <li>Can’t be the same as a previous password</li>
                        </ul>
                    </div>
                </div>
                <button type="submit"  className="btn btn-primary">
                    Update Profile
                </button>
            </form>
        </div>
        </>
    );
}