import { usePage, Link } from "@inertiajs/react";

export default function HeroSection({ 
    heading = "Contact", 
    breadcrumbs = ["Home", "Contact"],
    backgroundImage = null
}){
    const { sectionimages } = usePage().props;
    
    // Use hero_background from database if available, otherwise use prop or fallback
    const heroImage = backgroundImage || 
        (sectionimages?.hero_background ? `/storage/${sectionimages.hero_background}` : 'https://placehold.co/1900x1267');
    
    return(
        <>
        <section className="site-hero inner-page overlay" style={{backgroundImage: `url(${heroImage})`}} data-stellar-background-ratio="0.5">
            <div className="container">
                <div className="row site-hero-inner justify-content-center align-items-center">
                <div className="col-md-10 text-center" data-aos="fade">
                    <h1 className="heading mb-3">{heading}</h1>
                    <ul className="custom-breadcrumbs mb-4">
                    {breadcrumbs.map((crumb, index) => (
                        <>
                            {index > 0 && <li key={`bullet-${index}`}>•</li>}
                            <li key={index}>
                                {index === 0 ? (
                                    <Link href="/">{crumb}</Link>
                                ) : (
                                    crumb
                                )}
                            </li>
                        </>
                    ))}
                    </ul>
                </div>
                </div>
            </div>

            <a className="mouse smoothscroll" href="#next">
                <div className="mouse-icon">
                <span className="mouse-wheel"></span>
                </div>
            </a>
            </section>
        </>
    );
}