export default function Intro({ banner = null }){
    const backgroundImage = banner?.photo 
        ? `/storage/${banner.photo}` 
        : 'https://placehold.co/1900x1267';
    
    const title = banner?.title || 'Welcome To Matergo Hotel';
    const content = banner?.content || 'A Best Place To Stay';

    return(
        <>
        <section className="site-hero overlay" style={{backgroundImage: `url(${backgroundImage})`}} data-stellar-background-ratio="0.5">
        <div className="container">
            <div className="row site-hero-inner justify-content-center align-items-center">
            <div className="col-md-10 text-center" data-aos="fade-up">
                <span className="custom-caption text-uppercase text-white d-block mb-3">{title}</span>
                <h1 className="heading">{content}</h1>
            </div>
            </div>
        </div>

        <a className="mouse smoothscroll" href="#next">
            <div className="mouse-icon">
            <span className="mouse-wheel"></span>
            </div>
        </a>
        </section>
        </>
    );
}