import { Link } from '@inertiajs/react';

export default function Services({ services = [] }) {
    // Filter active services and sort by display_order
    const activeServices = services
        .filter(service => service.status)
        .sort((a, b) => (a.display_order || 0) - (b.display_order || 0));

    // Default services if none provided (fallback) - No placeholder images, icon-only
    const defaultServices = [
        {
            id: 1,
            name: 'Accommodation',
            description: 'Comfortable and luxurious rooms for your stay',
            photo: null,
            icon: 'fe fe-home',
            link: '/rooms',
        },
        {
            id: 2,
            name: 'Restaurant & Bar',
            description: 'Delicious cuisine and refreshing beverages',
            photo: null,
            icon: 'fe fe-coffee',
            link: '/dining',
        },
        {
            id: 3,
            name: 'Conference Room Rental',
            description: 'Perfect venues for meetings and events',
            photo: null,
            icon: 'fe fe-calendar',
            link: '/meetings-events',
        },
        {
            id: 4,
            name: 'Swimming Pool',
            description: 'Relax and unwind in our beautiful pool',
            photo: null,
            icon: 'fe fe-droplet',
            link: '#',
        },
        {
            id: 5,
            name: 'Catering Services',
            description: 'Professional catering for your special events',
            photo: null,
            icon: 'fe fe-menu',
            link: '#',
        },
        {
            id: 6,
            name: 'Tour Guide Services',
            description: 'Explore the area with our expert guides',
            photo: null,
            icon: 'fe fe-map',
            link: '#',
        },
    ];

    const servicesToDisplay = activeServices.length > 0 ? activeServices : defaultServices;

    return (
        <>
            <section className="section bg-light">
                <div className="container">
                    <div className="row justify-content-center text-center mb-5">
                        <div className="col-md-7">
                            <h2 className="heading" data-aos="fade-up">Our Services</h2>
                            <p data-aos="fade-up" data-aos-delay="100">
                                Discover the range of services we offer to make your stay exceptional
                            </p>
                        </div>
                    </div>

                    <div className="row">
                        {servicesToDisplay.map((service, index) => {
                            const hasPhoto = service.photo && service.photo.trim() !== '';
                            const imageUrl = hasPhoto ? `/storage/${service.photo}` : null;
                            
                            const serviceLink = service.link && service.link !== '#' 
                                ? service.link 
                                : '#';

                            return (
                                <div 
                                    key={service.id || index} 
                                    className="col-md-6 col-lg-4 mb-4" 
                                    data-aos="fade-up" 
                                    data-aos-delay={index * 100}
                                >
                                    <div className="service-card bg-white border rounded overflow-hidden h-100 shadow-sm">
                                        {serviceLink !== '#' ? (
                                            <Link href={serviceLink} className="text-decoration-none">
                                                {hasPhoto ? (
                                                    <div className="service-image-wrapper position-relative" style={{ height: '250px', overflow: 'hidden' }}>
                                                        <img 
                                                            src={imageUrl} 
                                                            alt={service.name}
                                                            className="img-fluid w-100 h-100"
                                                            style={{ objectFit: 'cover', transition: 'transform 0.3s ease' }}
                                                            onMouseEnter={(e) => e.currentTarget.style.transform = 'scale(1.05)'}
                                                            onMouseLeave={(e) => e.currentTarget.style.transform = 'scale(1)'}
                                                        />
                                                        {service.icon && (
                                                            <div 
                                                                className="service-icon position-absolute"
                                                                style={{
                                                                    top: '20px',
                                                                    right: '20px',
                                                                    width: '60px',
                                                                    height: '60px',
                                                                    backgroundColor: 'rgba(201, 162, 39, 0.9)',
                                                                    borderRadius: '50%',
                                                                    display: 'flex',
                                                                    alignItems: 'center',
                                                                    justifyContent: 'center',
                                                                    color: '#fff',
                                                                    fontSize: '24px',
                                                                    boxShadow: '0 4px 12px rgba(0,0,0,0.2)'
                                                                }}
                                                            >
                                                                <i className={service.icon}></i>
                                                            </div>
                                                        )}
                                                    </div>
                                                ) : (
                                                    <div 
                                                        className="service-icon-wrapper d-flex align-items-center justify-content-center"
                                                        style={{ 
                                                            height: '250px', 
                                                            backgroundColor: '#f8f9fa',
                                                            borderBottom: '1px solid #dee2e6'
                                                        }}
                                                    >
                                                        {service.icon ? (
                                                            <div 
                                                                className="service-icon-large"
                                                                style={{
                                                                    width: '120px',
                                                                    height: '120px',
                                                                    backgroundColor: '#c9a227',
                                                                    borderRadius: '50%',
                                                                    display: 'flex',
                                                                    alignItems: 'center',
                                                                    justifyContent: 'center',
                                                                    color: '#fff',
                                                                    fontSize: '48px',
                                                                    boxShadow: '0 4px 12px rgba(0,0,0,0.2)'
                                                                }}
                                                            >
                                                                <i className={service.icon}></i>
                                                            </div>
                                                        ) : (
                                                            <i className="fe fe-grid" style={{ fontSize: '64px', color: '#c9a227', opacity: 0.5 }}></i>
                                                        )}
                                                    </div>
                                                )}
                                                <div className="p-4">
                                                    <h4 className="mb-3 text-dark">{service.name}</h4>
                                                    <p className="text-muted mb-0" style={{ lineHeight: '1.6' }}>
                                                        {service.description || 'Experience our exceptional service'}
                                                    </p>
                                                </div>
                                            </Link>
                                        ) : (
                                            <>
                                                {hasPhoto ? (
                                                    <div className="service-image-wrapper position-relative" style={{ height: '250px', overflow: 'hidden' }}>
                                                        <img 
                                                            src={imageUrl} 
                                                            alt={service.name}
                                                            className="img-fluid w-100 h-100"
                                                            style={{ objectFit: 'cover' }}
                                                        />
                                                        {service.icon && (
                                                            <div 
                                                                className="service-icon position-absolute"
                                                                style={{
                                                                    top: '20px',
                                                                    right: '20px',
                                                                    width: '60px',
                                                                    height: '60px',
                                                                    backgroundColor: 'rgba(201, 162, 39, 0.9)',
                                                                    borderRadius: '50%',
                                                                    display: 'flex',
                                                                    alignItems: 'center',
                                                                    justifyContent: 'center',
                                                                    color: '#fff',
                                                                    fontSize: '24px',
                                                                    boxShadow: '0 4px 12px rgba(0,0,0,0.2)'
                                                                }}
                                                            >
                                                                <i className={service.icon}></i>
                                                            </div>
                                                        )}
                                                    </div>
                                                ) : (
                                                    <div 
                                                        className="service-icon-wrapper d-flex align-items-center justify-content-center"
                                                        style={{ 
                                                            height: '250px', 
                                                            backgroundColor: '#f8f9fa',
                                                            borderBottom: '1px solid #dee2e6'
                                                        }}
                                                    >
                                                        {service.icon ? (
                                                            <div 
                                                                className="service-icon-large"
                                                                style={{
                                                                    width: '120px',
                                                                    height: '120px',
                                                                    backgroundColor: '#c9a227',
                                                                    borderRadius: '50%',
                                                                    display: 'flex',
                                                                    alignItems: 'center',
                                                                    justifyContent: 'center',
                                                                    color: '#fff',
                                                                    fontSize: '48px',
                                                                    boxShadow: '0 4px 12px rgba(0,0,0,0.2)'
                                                                }}
                                                            >
                                                                <i className={service.icon}></i>
                                                            </div>
                                                        ) : (
                                                            <i className="fe fe-grid" style={{ fontSize: '64px', color: '#c9a227', opacity: 0.5 }}></i>
                                                        )}
                                                    </div>
                                                )}
                                                <div className="p-4">
                                                    <h4 className="mb-3">{service.name}</h4>
                                                    <p className="text-muted mb-0" style={{ lineHeight: '1.6' }}>
                                                        {service.description || 'Experience our exceptional service'}
                                                    </p>
                                                </div>
                                            </>
                                        )}
                                    </div>
                                </div>
                            );
                        })}
                    </div>
                </div>
            </section>
        </>
    );
}



