export default function Testimonial({ testimonials = [] }){
    // Fallback testimonials if none exist in database
    const fallbackTestimonials = [
        {
            id: 1,
            name: 'Jean Smith',
            message: 'A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.',
            photo: 'https://placehold.co/800x800'
        },
        {
            id: 2,
            name: 'John Doe',
            message: 'Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.',
            photo: 'https://placehold.co/800x800'
        },
        {
            id: 3,
            name: 'John Doe',
            message: 'When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane.',
            photo: 'https://placehold.co/800x800'
        }
    ];

    // Use database testimonials if available, otherwise use fallback
    const displayTestimonials = testimonials && testimonials.length > 0 ? testimonials : fallbackTestimonials;

    return(
        <>
        <section className="section testimonial-section">
        <div className="container">
            <div className="row justify-content-center text-center mb-5">
            <div className="col-md-7">
                <h2 className="heading" data-aos="fade-up">People Says</h2>
            </div>
            </div>
            <div className="row">
            <div className="js-carousel-2 owl-carousel mb-5" data-aos="fade-up" data-aos-delay="200">
                {displayTestimonials.map((testimonial) => {
                    // Determine photo path: 
                    // - If it's a URL (starts with http/https), use as-is
                    // - If it starts with /assets, use as-is
                    // - Otherwise prepend /storage/
                    // - If no photo, use placeholder
                    const photoPath = testimonial.photo 
                        ? (testimonial.photo.startsWith('http://') || testimonial.photo.startsWith('https://'))
                            ? testimonial.photo
                            : (testimonial.photo.startsWith('/assets') ? testimonial.photo : `/storage/${testimonial.photo}`)
                        : 'https://placehold.co/800x800'; // fallback placeholder
                    
                    return (
                        <div key={testimonial.id} className="testimonial text-center slider-item">
                            <div className="author-image mb-3">
                                <img 
                                    src={photoPath} 
                                    alt={testimonial.name} 
                                    className="rounded-circle mx-auto" 
                                />
                            </div>
                            <blockquote>
                                <p>&ldquo;{testimonial.message}&rdquo;</p>
                            </blockquote>
                            <p><em>&mdash; {testimonial.name}</em></p>
                        </div>
                    );
                })}
            </div>
                {/* END slider */}
            </div>

        </div>
        </section>
        </>
    );
}