<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $emailData['subject'] }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #333; line-height: 1.6; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #007BFF; padding: 10px; color: #fff; text-align: center; }
        .content { margin-top: 20px; }
        .footer { margin-top: 30px; font-size: 12px; color: #777; text-align: center; }
        .original-message { background: #f9f9f9; padding: 10px; border-left: 4px solid #007BFF; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Response to Your Inquiry</h2>
        </div>
        <div class="content">
            <p>Dear Valued Customer,</p>
            <p>{!! $emailData['response_to_message'] !!}
            </p>

            <hr>
            <h4>Original Message</h4>
            <p><strong>Subject:</strong> {{ $emailData['original_subject'] }}</p>
            <div class="original-message">
                {!! nl2br(e($emailData['original_message'])) !!}
            </div>
            <p>Thank you for reaching out. Please feel free to reply if you have any further questions.</p>
            <p>Whatsapp or call: +255698338014 | Email: info@matergohotel.bi </p>

        </div>
        <div class="footer">
            <p>&copy; {{ date('Y') }} Matergo Hotel. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
